/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.modifiers.misc;

import com.xiaoyue.tinkers_ingenuity.content.library.helper.BreakLogicHelper;
import com.xiaoyue.tinkers_ingenuity.generic.XIModifier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockHarvestModifierHook;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.aoe.AreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.BlockSideHitListener;

public class EarthCoreCrush
extends XIModifier {
    public EarthCoreCrush() {
        MinecraftForge.EVENT_BUS.addListener(this::onLeftBlock);
    }

    @Override
    public boolean isSingleLevel() {
        return true;
    }

    public int getPriority() {
        return 222;
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction sidHit, boolean isEffective, float miningSpeedModifier) {
        if (!event.getEntity().m_21023_(MobEffects.f_19599_)) {
            event.setNewSpeed(Float.MAX_VALUE);
        }
    }

    private void onLeftBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        Level world = player.m_9236_();
        BlockState state = world.m_8055_(pos);
        if (!player.m_7500_() && !player.m_21023_(MobEffects.f_19599_)) {
            ToolStack tool = EarthCoreCrush.getHeldTool((LivingEntity)player, (InteractionHand)InteractionHand.MAIN_HAND);
            if (tool == null || tool.isBroken() || tool.getModifierLevel((Modifier)this) < 1) {
                return;
            }
            state.m_60734_().m_5707_(world, pos, state, player);
            if (world instanceof ServerLevel) {
                Direction sideHit;
                ToolHarvestContext context;
                ServerLevel serverLevel = (ServerLevel)world;
                ItemStack toolStack = player.m_21205_();
                if (BreakLogicHelper.breakBlock(tool, toolStack, context = new ToolHarvestContext(serverLevel, (LivingEntity)player, state, pos, sideHit = BlockSideHitListener.getSideHit((Player)player), true, true))) {
                    Iterable extraBlocks = ((AreaOfEffectIterator)tool.getHook(ToolHooks.AOE_ITERATOR)).getBlocks((IToolStackView)tool, toolStack, player, state, world, pos, BlockSideHitListener.getSideHit((Player)player), AreaOfEffectIterator.AOEMatchType.BREAKING);
                    for (BlockPos extraPos : extraBlocks) {
                        BlockState extraState = world.m_8055_(extraPos);
                        if (extraState.m_60795_()) continue;
                        ToolHarvestLogic.breakExtraBlock((ToolStack)tool, (ItemStack)toolStack, (ToolHarvestContext)context.forPosition(extraPos.m_7949_(), extraState));
                    }
                    for (ModifierEntry entry : tool.getModifierList()) {
                        ((BlockHarvestModifierHook)entry.getHook(ModifierHooks.BLOCK_HARVEST)).finishHarvest((IToolStackView)tool, entry, context, true);
                    }
                    BreakLogicHelper.dropItems(state, pos, (Level)serverLevel);
                }
            }
        }
    }
}

